<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../gUtil/GestoreTabella.php";
    include "../../../classi/Tabella.php";
    include "../../../include/utilEcommerce.php";
    
    $impostazioniEcommerce = $geecomDb->leggiSingolaRiga("geecEc_impostazioni",1);
    $impostazioniPagamenti = $geecomDb->leggiSingolaRiga("geecEc_impostazioniPagamenti",1);
    $impostazioniCarrello  = $geecomDb->leggiSingolaRiga("geecEc_impostazioniPaginaCarrello",1);
    $impostazioniLingue    = $geecomDb->leggiSingolaRiga("geecB_impostazioniLingue",1);
    
    $linguaSelezionata = isset($_GET["lingua"]) ? filter_input(INPUT_GET,"lingua",FILTER_SANITIZE_ADD_SLASHES) : $impostazioniLingue["linguaPrincipale"];
    $statoSelezionato  = isset($_GET["stato"]) ? filter_input(INPUT_GET,"stato",FILTER_SANITIZE_ADD_SLASHES) : "";
        
    $datiComponenteEcommerce = $geecomDb->leggiSingolaRiga("geecB_componenti","Ecommerce","nome");
    
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_ADD_SLASHES) : "";

    $parametriRicerca = array("nome"=>$cerca);

    if(!isset($_GET["status"])) {
        $status = 0;
    }
    else {    
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Amministrazione del componente e-commerce</title>

    <?php
        include "../include/cssBaseComponenti.php";
    ?>
</head>

<body>
   
    <?php  
        include "../../include/barraSuperiore.php";

        include "../../include/header.php";

        include "../../include/barraMenu.php";
    ?>
    
    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row py-4">
       	 <div class="col-12">
                <?php 
                    if($status==200) {
                        echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                            Profili social aggiornati
                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                <span aria-hidden=\"true\">&times;</span>
                            </button>
                        </div>";
                    }
                    else if($status==260) {
                        echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                            Impostazioni pagamento aggiornate
                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                <span aria-hidden=\"true\">&times;</span>
                            </button>
                        </div>";
                    }
                    else if($status==270) {
                        echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                            Impostazioni generali aggiornate
                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                <span aria-hidden=\"true\">&times;</span>
                            </button>
                        </div>";
                    }
                    else if($status==280) {
                        echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                            Incentivi all'acquisto aggiornati
                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                <span aria-hidden=\"true\">&times;</span>
                            </button>
                        </div>";
                    }
                ?>
		</div>
                <div class="col-2 col-sm-4 col-lg-3 col-xl-2 pr-0 align-self-start sticky-top">
                    <ul class="nav nav-tabs nav-tabs--vertical nav-tabs--left">
                        <li class="nav-item">
                            <a href="#impostazioni" class="nav-link <?php echo(($status==270) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="impostazioni generali"><i class="fas fa-sliders-h d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Impostazioni</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#statistiche" class="nav-link <?php echo(($status==100) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="aspetto"><i class="far fa-chart-bar d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Statistiche</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#prodotti" class="nav-link <?php echo(($status==0) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="prodotti"><i class="fas fa-boxes d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Prodotti</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#categorieProdotti" class="nav-link <?php echo(($status==205) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="prodotti"><i class="fas fa-tags d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Categorie prodotti</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#buoniSconto" class="nav-link <?php echo(($status==210 || $status==101) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="prodotti"><i class="fas fa-percentage d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Buoni sconto</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#scontiGruppi" class="nav-link <?php echo(($status==220 || $status==102) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="prodotti"><i class="fas fa-user-friends d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Sconti gruppi</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#ordini" class="nav-link <?php echo(($status==230 || $status==103) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="prodotti"><i class="fas fa-euro-sign d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Ordini</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#abbonamenti" class="nav-link <?php echo(($status==240 || $status==104) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="prodotti"><i class="far fa-id-badge d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Abbonamenti</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#spedizioni" class="nav-link <?php echo(($status==250) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="prodotti"><i class="fas fa-truck d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Spedizioni</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#metodiPagamento" class="nav-link <?php echo(($status==260) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="prodotti"><i class="far fa-credit-card d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Metodi di pagamento</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#incentiviAcquisto" class="nav-link <?php echo(($status==280) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="prodotti"><i class="far fa-sticky-note d-sm-inline-block d-flex justify-content-center fa-fw"></i><span class="d-none d-sm-inline-block ml-sm-2">Incentivi all'acquisto</span></a>
                        </li>
                    </ul>
                    <div class="text-center text-black-50 mt-3"><?php echo $datiComponenteEcommerce["versione"] ?></div>
                </div>
                <div class="col-10 col-sm-8 col-lg-9 col-xl-10">
                    <div class="tab-content">
                        <div class="tab-pane fade show <?php echo(($status==270) ? "active" : "")  ?>" id="impostazioni" role="tabpanel">
                            <?php 
                                include "include/impostazioni.php";
                            ?>
                        </div>
                        <div class="tab-pane fade show <?php echo(($status==100) ? "active" : "")  ?>" id="statistiche" role="tabpanel">
                            <?php 
                                include "include/statistiche.php";
                            ?>
                        </div>
                        <div class="tab-pane fade show <?php echo(($status==0) ? "active" : "")  ?>" id="prodotti" role="tabpanel">
                            <?php 
                                include "include/prodotti.php"; 
                            ?>                  
                        </div>
                        <div class="tab-pane fade show <?php echo(($status==205) ? "active" : "")  ?>" id="categorieProdotti" role="tabpanel">
                            <?php 
                                include "include/categorieProdotti.php"; 
                            ?>                  
                        </div>
                        <div class="tab-pane fade show <?php echo(($status==210 || $status==101) ? "active" : "")  ?>" id="buoniSconto" role="tabpanel">
                            <?php 
                                include "include/buoniSconto.php"; 
                            ?>                  
                        </div>
                        <div class="tab-pane fade show <?php echo(($status==220 || $status==102) ? "active" : "")  ?>" id="scontiGruppi" role="tabpanel">
                            <?php 
                               include "include/scontiGruppi.php"; 
                            ?>                  
                        </div>
                        <div class="tab-pane fade show <?php echo(($status==230 || $status==103) ? "active" : "")  ?>" id="ordini" role="tabpanel">
                            <?php 
                                include "include/ordini.php"; 
                            ?>                  
                        </div>
                        <div class="tab-pane fade show <?php echo(($status==240 || $status==104) ? "active" : "")  ?>" id="abbonamenti" role="tabpanel">
                            <?php 
                                include "include/abbonamenti.php"; 
                            ?>                  
                        </div>
                        <div class="tab-pane fade show <?php echo(($status==250) ? "active" : "")  ?>" id="spedizioni" role="tabpanel">
                            <?php 
                                include "include/spedizioni.php"; 
                            ?>                  
                        </div>
                        <div class="tab-pane fade show <?php echo(($status==260) ? "active" : "")  ?>" id="metodiPagamento" role="tabpanel">
                            <?php 
                                include "include/metodiPagamento.php"; 
                            ?>
                        </div>
                        <div class="tab-pane fade show <?php echo(($status==280) ? "active" : "")  ?>" id="incentiviAcquisto" role="tabpanel">
                            <?php 
                                include "include/incentiviAcquisto.php"; 
                            ?>
                        </div>
                    </div>
                </div>

                    
                </div>
            </div>
        </div>
    </main>
    
    <?php 
        include "../../include/footer.php";
        
        include "../include/modal/cambiaPassword.php";
        
        include "../../include/modal/modalMenuComponenti.php";
        
        include "../../include/modal/operazioneCompletata.php";
        
    ?>
    
        <div class="modal fade" id="modalModificaAreaGeografica" tabindex="-1" role="dialog" aria-labelledby="modifica-voce-menu" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">Modifica area geografica</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                          <form>
                                <input type="text" class="d-none" id="idAreaDaModificare" name="id">

                                <div class="form-group">
                                    <label for="nome-voce-menu-1">Nome</label>
                                    <input id="modificaNomeAreaGeografica" type="text" class="form-control" id="nomeTagModificare" name="nome" placeholder="Nome">
                                </div>
                                    
                                <div class="form-group">
                                    <label for="nome-voce-menu-1">Nazioni appartenenti</label>
                                    <textarea id="modificaNazioniAppartenentiAreaGeografica" class="form-control" rows="2"></textarea>
                                </div>
                          </form>
                    </div>
                    <div class="modal-footer">
                          <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                          <button type="button" class="btn btn-primary btn-sm" onclick="eseguiModificaAreaGeografica()"><i class="fas fa-check"></i> Salva</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="modalModificaZonaDisagiata" tabindex="-1" role="dialog" aria-labelledby="modifica-voce-menu" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">Modifica zona disagiata</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                          <form>
                                <input type="text" class="d-none" id="idZonaDaModificare" name="id">

                                <div class="form-group">
                                    <label for="nome-voce-menu-1">Nome</label>
                                    <input id="modificaNomeZonaDisagiata" type="text" class="form-control" name="nome">
                                </div>
                                    
                                <div class="form-group">
                                    <label for="nome-voce-menu-1">CAP inizio</label>
                                    <input id="modificaCapInizio" type="text" class="form-control" name="nome">
                                </div>
                                
                                <div class="form-group">
                                    <label for="nome-voce-menu-1">CAP fine</label>
                                    <input id="modificaCapFine" type="text" class="form-control" name="nome">
                                </div>
                          </form>
                    </div>
                    <div class="modal-footer">
                          <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                          <button type="button" class="btn btn-primary btn-sm" onclick="eseguiModificaZonaDisagiata()"><i class="fas fa-check"></i> Salva</button>
                    </div>
                </div>
            </div>
        </div>
    
        <div class="modal fade" id="modalEliminaOpzioneSpedizione" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Conferma eliminazione</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="align-self-center text-center">
                            <span class="align-self-center text-primary"><em id="nomeElementoDaEliminare"></em></span>
                        </div>
                        <input type="text" class="d-none" id="idElementoDaEliminare">
                        <input type="text" class="d-none" id="tipoElementoDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneOpzioneSpedizione('../../../')"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
    
        <div class="modal fade" id="modalEliminaCategoria" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
              <div class="modal-content">
                  <div class="modal-header">
                      <h5 class="modal-title">Eliminare la categoria?</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                      <span aria-hidden="true">&times;</span>
                      </button>
                  </div>
                  <div class="modal-body">
                      <div class="d-flex flex-row justify-content-center">
                          <input type="text" class="d-none" id="categoriaDaEliminare" >
                          <div class="align-self-center text-center">
                              <span class="align-self-center text-primary"><em id="nomeCategoriaDaEliminare"></em></span>
                          </div>
                      </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Annulla</button>
                    <button type="button" class="btn btn-primary" onclick="{eliminaCategoria('../../../')}" >Elimina</button>
                  </div>
              </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.Modal box-->
        
        <div class="modal fade" id="modalEliminaProdotto" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
              <div class="modal-content">
                  <div class="modal-header">
                      <h5 class="modal-title">Eliminare il prodotto?</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                      <span aria-hidden="true">&times;</span>
                      </button>
                  </div>
                  <div class="modal-body">
                      <div class="d-flex flex-row justify-content-center">
                          <input type="text" class="d-none" id="prodottoDaEliminare" >
                          <div class="align-self-center text-center">
                              <span class="align-self-center text-primary"><em id="nomeProdottoDaEliminare"></em></span>
                          </div>
                      </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Annulla</button>
                    <button type="button" class="btn btn-primary" onclick="{eseguiEliminazioneProdotto()}" >Elimina</button>
                  </div>
              </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.Modal box-->
        
        <div class="modal fade" id="modalModificaStatoOrdine" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
              <div class="modal-content">
                  <div class="modal-header">
                      <h5 class="modal-title">Conferma modifica stato per l'ordine <span id="idOrdineDaModificare"></span></h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                      <span aria-hidden="true">&times;</span>
                      </button>
                  </div>
                  <div class="modal-body">
                      <div class="d-flex flex-row justify-content-center">
                          <input type="text" class="d-none" id="ordineDaModificare" >
                          <div class="align-self-center text-center">
                              <span class="align-self-center text-primary"><em id="statoOrdineDaModificare"></em></span>
                          </div>
                      </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Annulla</button>
                    <button type="button" class="btn btn-primary" onclick="{eseguiModificaStato()}" >Conferma</button>
                  </div>
              </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.Modal box-->
        
        <div class="modal fade" id="modalEliminaBuonoSconto" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
              <div class="modal-content">
                  <div class="modal-header">
                      <h5 class="modal-title">Eliminare il buono sconto?</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                      <span aria-hidden="true">&times;</span>
                      </button>
                  </div>
                  <div class="modal-body">
                      <div class="d-flex flex-row justify-content-center">
                          <input type="text" class="d-none" id="buonoScontoDaEliminare" >
                          <div class="align-self-center text-center">
                              <span class="align-self-center text-primary"><em id="nomeBuonoScontoDaEliminare"></em></span>
                          </div>
                      </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Annulla</button>
                    <button type="button" class="btn btn-primary" onclick="{eseguiEliminazioneBuonoSconto()}" >Elimina</button>
                  </div>
              </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.Modal box-->
        
        <div class="modal fade" id="modalEliminaSpedizione" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
              <div class="modal-content">
                  <div class="modal-header">
                      <h5 class="modal-title">Eliminare la spedizione?</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                      <span aria-hidden="true">&times;</span>
                      </button>
                  </div>
                  <div class="modal-body">
                      <div class="d-flex flex-row justify-content-center">
                          <input type="text" class="d-none" id="spedizioneDaEliminare" >
                          <div class="align-self-center text-center">
                              <span class="align-self-center text-primary"><em id="nomeSpedizioneDaEliminare"></em></span>
                          </div>
                      </div>
                  </div>
                  <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Annulla</button>
                    <button type="button" class="btn btn-primary" onclick="{eseguiEliminazioneSpedizione()}" >Elimina</button>
                  </div>
              </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.Modal box-->
    <?php
        include "../include/jsBaseComponenti.php";
    ?>
	
    <script type="text/javascript">

        function apriPopupEliminaProdotto(idProdotto,nome) {
            document.getElementById("prodottoDaEliminare").value = idProdotto;
            document.getElementById("nomeProdottoDaEliminare").innerHTML = nome;
            $('#modalEliminaProdotto').modal('show');
        }
        
        function eseguiEliminazioneProdotto() {
            var id   = $('#prodottoDaEliminare').val();
            $.ajax({
                type:"POST",
                url:"../../../controller/ecommerce/controllerProdotti.php",
                data:{
                    operazione:"elimina",
                    id:id
                },
                success:function(esito) {
                    if(esito=="ok") {
                        document.getElementById("rigaProdotto"+id).className = "d-none";
                        $('#modalEliminaProdotto').modal('hide');
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
        
        function apriPopupModificaStatoOrdine(idOrdine,stato) {
            document.getElementById("ordineDaModificare").value          = idOrdine;
            document.getElementById("idOrdineDaModificare").innerHTML    = idOrdine;
            document.getElementById("statoOrdineDaModificare").innerHTML = stato;
            $('#modalModificaStatoOrdine').modal('show');
        }
        
        function eseguiModificaStato() {
            var id    = $('#ordineDaModificare').val();
            var stato = document.getElementById("statoOrdineDaModificare").innerHTML;
            
            $.ajax({
                type:"POST",
                url:"../../../controller/ecommerce/controllerOrdini.php",
                data:{
                    operazione:"modificaStato",
                    id:id,
                    stato:stato
                },
                success:function(esito) {
                    if(esito=="ok") {
                        document.getElementById("labelOperazioneCompletata").innerHTML = "Stato ordine cambiato";
                        $('#modalModificaStatoOrdine').modal('hide');
                        $('#modalOperazioneCompletata').modal('show');
                    }
                    else {
                        alert(esito);
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
        
        function apriPopupEliminaBuonoSconto(idProdotto,nome) {
            document.getElementById("buonoScontoDaEliminare").value = idProdotto;
            document.getElementById("nomeBuonoScontoDaEliminare").innerHTML = nome;
            $('#modalEliminaBuonoSconto').modal('show');
        }
        
        function eseguiEliminazioneBuonoSconto() {
            var id   = $('#buonoScontoDaEliminare').val();
            $.ajax({
                type:"POST",
                url:"../../../controller/ecommerce/controllerBuoniSconto.php",
                data:{
                    operazione:"elimina",
                    id:id
                },
                success:function(esito) {
                    if(esito=="ok") {
                        document.getElementById("rigaBuonoSconto"+id).className = "d-none";
                        $('#modalEliminaBuonoSconto').modal('hide');
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
        
        function apriPopupEliminaSpedizione(idSpedizione,nome) {
            document.getElementById("spedizioneDaEliminare").value = idSpedizione;
            document.getElementById("nomeSpedizioneDaEliminare").innerHTML = nome;
            $('#modalEliminaSpedizione').modal('show');
        }
        
        function eseguiEliminazioneSpedizione() {
            var id   = $('#spedizioneDaEliminare').val();
            $.ajax({
                type:"POST",
                url:"../../../controller/ecommerce/controllerSpedizioni.php",
                data:{
                    operazione:"elimina",
                    id:id
                },
                success:function(esito) {
                    if(esito=="ok") {
                        document.getElementById("rigaSpedizione"+id).className = "d-none";
                        $('#modalEliminaSpedizione').modal('hide');
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
        
        function eliminaOpzioneSpedizione(idUtente,tipo,nome) {
            document.getElementById("idElementoDaEliminare").value   = idUtente;
            document.getElementById("tipoElementoDaEliminare").value = tipo;
            document.getElementById("nomeElementoDaEliminare").innerHTML = nome;
            $('#modalEliminaOpzioneSpedizione').modal('show');
        }
        
        function eseguiEliminazioneOpzioneSpedizione() {
            var id   = $('#idElementoDaEliminare').val();
            var tipo = $('#tipoElementoDaEliminare').val();
            var tipoPrimaLetteraMaiuscola = tipo.charAt(0).toUpperCase() + tipo.slice(1);
            $.ajax({
                type:"POST",
                url:"../../../controller/ecommerce/controllerSpedizioni.php",
                data:{
                    operazione:"elimina"+tipoPrimaLetteraMaiuscola,
                    id:id
                },
                success:function(esito) {
                    if(esito=="ok") {
                        document.getElementById(tipo+id).className = "d-none";
                        $('#modalEliminaOpzioneSpedizione').modal('hide');
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
        
        function modificaImpostazioniAreeGeografiche() {
            var nazioniDaVisualizzare   = $('#nazioniDaVisualizzare').val();
            if(document.getElementById("attivaAreeGeografiche").checked) {
                var attivaAreaeGeografiche = "si";
            }
            else {
                var attivaAreaeGeografiche = "no";
            }

            $.ajax({
                type:"POST",
                url:"../../../controller/ecommerce/controllerSpedizioni.php",
                data:{
                    operazione:"modificaImpostazioniAreeGeografiche",
                    attivaAreaeGeografiche:attivaAreaeGeografiche,
                    nazioniDaVisualizzare:nazioniDaVisualizzare
                },
                success:function(esito) {
                    if(esito=="ok") {
                        document.getElementById("labelOperazioneCompletata").innerHTML = "Impostazioni aree geografiche aggiornate";
                        $('#modalOperazioneCompletata').modal('show');
                    }
                    else {
                        alert("Si è verificato un errore, contatta l'amministratore del sito")
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
        
        function creaAreaGeografica() {
            var nomeAreaGeografica  = $('#nomeAreaGeografica').val();
            var nazioniAppartenenti = $('#nazioniAppartenenti').val();

            $.ajax({
                type:"POST",
                url:"../../../controller/ecommerce/controllerSpedizioni.php",
                data:{
                    operazione:"creaAreaGeografica",
                    nomeAreaGeografica:nomeAreaGeografica,
                    nazioniAppartenenti:nazioniAppartenenti
                },
                success:function(esito) {
                    if(esito=="ok") {
                        aggiornaDivAreeGeografiche();
                    }
                    else {
                        alert("Si è verificato un errore, contatta l'amministratore del sito")
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
        
        function modificaAreaGeografica(idArea,nome,nazioni) {
            document.getElementById("idAreaDaModificare").value = idArea;
            document.getElementById("modificaNomeAreaGeografica").value = nome;
            document.getElementById("modificaNazioniAppartenentiAreaGeografica").value = nazioni;
            $('#modalModificaAreaGeografica').modal('show');
        }

        function eseguiModificaAreaGeografica() {
            var idAreaDaModificare  = $('#idAreaDaModificare').val();
            var nomeAreaGeografica  = $('#modificaNomeAreaGeografica').val();
            var nazioniAppartenenti = $('#modificaNazioniAppartenentiAreaGeografica').val();

            $.ajax({
                type:"POST",
                url:"../../../controller/ecommerce/controllerSpedizioni.php",
                data:{
                    operazione:"modificaAreaGeografica",
                    idArea:idAreaDaModificare,
                    nomeAreaGeografica:nomeAreaGeografica,
                    nazioniAppartenenti:nazioniAppartenenti
                },
                success:function(esito) {
                    if(esito=="ok") {
                        aggiornaDivAreeGeografiche();
                        $('#modalModificaAreaGeografica').modal('hide');               
                    }
                    else {
                        alert("Si è verificato un errore, contatta l'amministratore del sito")
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
        
        function aggiornaDivAreeGeografiche() {
            $.ajax({
                type:"POST",
                url:"../../../controller/ecommerce/controllerSpedizioni.php",
                data:{
                    operazione:"stampaAreeGeografiche"
                },
                success:function(result) {
                    document.getElementById("divAreeGeografiche").innerHTML = result;
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    alert(xhr.status+" "+thrownError);
                }
            });
        }
        
        function creaZonaDisagiata() {
            var nomeZonaDisagiata = $('#nomeZonaDisagiata').val();
            var CAPinizio         = $('#CAPInizioZonaDisagiata').val();
            var CAPfine           = $('#CAPFineZonaDisagiata').val();

            $.ajax({
                type:"POST",
                url:"../../../controller/ecommerce/controllerSpedizioni.php",
                data:{
                    operazione:"creaZonaDisagiata",
                    nomeZonaDisagiata:nomeZonaDisagiata,
                    CAPinizio:CAPinizio,
                    CAPfine:CAPfine,
                },
                success:function(esito) {
                    if(esito=="ok") {
                        aggiornaDivZoneDisagiate();
                    }
                    else {
                        alert("Si è verificato un errore, contatta l'amministratore del sito")
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }

        function modificaZonaDisagiata(idZona,nome,capInizio,capFine) {
            document.getElementById("idZonaDaModificare").value        = idZona;
            document.getElementById("modificaNomeZonaDisagiata").value = nome;
            document.getElementById("modificaCapInizio").value         = capInizio;
            document.getElementById("modificaCapFine").value           = capFine;
            $('#modalModificaZonaDisagiata').modal('show');
        }

        function eseguiModificaZonaDisagiata() {
            var idZona            = $('#idZonaDaModificare').val();
            var nomeZonaDisagiata = $('#modificaNomeZonaDisagiata').val();
            var CAPinizio         = $('#modificaCapInizio').val();
            var CAPfine           = $('#modificaCapFine').val();

            $.ajax({
                type:"POST",
                url:"../../../controller/ecommerce/controllerSpedizioni.php",
                data:{
                    operazione:"modificaZonaDisagiata",
                    idZona:idZona,
                    nomeZonaDisagiata:nomeZonaDisagiata,
                    CAPinizio:CAPinizio,
                    CAPfine:CAPfine,
                },
                success:function(esito) {
                    if(esito=="ok") {
                        aggiornaDivZoneDisagiate();
                        $('#modalModificaZonaDisagiata').modal('hide');               
                    }
                    else {
                        alert("Si è verificato un errore, contatta l'amministratore del sito")
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
        
        function aggiornaDivZoneDisagiate() {
            $.ajax({
                type:"POST",
                url:"../../../controller/ecommerce/controllerSpedizioni.php",
                data:{
                    operazione:"stampaZoneDisagiate"
                },
                success:function(result) {
                    document.getElementById("divZoneDisagiate").innerHTML = result;
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    alert(xhr.status+" "+thrownError);
                }
            });
        }
        
        function modificaPercentualeScontoGruppo(idGruppo) {
            var percentualeSconto = document.getElementById("scontoGruppo"+idGruppo).value;
            $.ajax({
                type:"POST",
                url:"../../../controller/ecommerce/controllerImpostazioni.php",
                data:{
                    operazione:"modificaPercentualeScontoGruppo",
                    idGruppo:idGruppo,
                    percentualeSconto:percentualeSconto
                },
                success:function(result) {
                    document.getElementById("labelOperazioneCompletata").innerHTML = "Percentuale sconto per questo gruppo aggiornata";
                    $('#modalOperazioneCompletata').modal('show');
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    alert(xhr.status+" "+thrownError);
                }
            });
        }
        
        function spostaCategoriaInput(id) {
            var posizione = $('#nuovaPosizioneCategoria'+id).val();
            spostaCategoria(id,posizione);
        }

        function spostaCategoria(id,posizione) {
            $.ajax({
                type:"POST",
                url:"../../../controller/controllerCategorie.php",
                data:{
                    operazione:"spostaCategoria",
                    id:id,
                    posizione:posizione
                },
                success:function(result) {
                    if(result=="ok") {
                        aggiornaCategorie('../../../','ecommerce');
                    }
                    else {
                        alert(result);
                    }
                },
                error: function() {
                    alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                }
            });
        }
    </script>
    <script src="../../../plugins/apexcharts/apexcharts.min.js" type="text/javascript"></script>
        <?php 
            // creo il grafico del numero di ordini
            $datiStatistiche   = $geecomDb->leggiSingolaRiga("geecB_statistiche",1);

            $dataOggi          = new DateTime();
            $dataInstallazione = new DateTime($datiStatistiche["dataInstallazione"]);
            $differenzaGiorni  = ($dataOggi->diff($dataInstallazione))->days;
            
            $arrayOrdini = array();
            $arrayDate            = array();
            
            $elementiGrafico = 0;
            $dataDaNonSuperare = date("y-m-d",strtotime("+1 days"));
            $dataAttuale       = date("y-m-d");
            
            while($elementiGrafico<15) {
                $query    = "SELECT COUNT(*) FROM geecEc_ordini WHERE dataOrdine >= '$dataAttuale' AND dataOrdine <= '$dataDaNonSuperare'";
                $risQuery = $geecomDb->eseguiQueryLettura($query);
                $datiOrdini = $risQuery->fetch_array(MYSQLI_NUM);
                $arrayOrdini[count($arrayOrdini)] = $datiOrdini[0];
                $arrayDate[count($arrayDate)]                       = $dataAttuale;
                $elementiGrafico++;
                $dataDaNonSuperare = $dataAttuale;
                $dataAttuale       = date("y-m-d",strtotime("-$elementiGrafico days"));
                if($elementiGrafico>=$differenzaGiorni) {
                    break;
                }
            }
            
            $arrayDate  = array_reverse($arrayDate);
            $arrayOrdini = array_reverse($arrayOrdini);
        ?>
        <script>
            var options = {
                series: [{
                    name: "Visualizzazioni",
                    data: [<?php echo implode(",", $arrayOrdini) ?>]
                }],
                chart: {
                    height: 350,
                    type: 'line',
                    zoom: {
                        enabled: false
                    }
                },
                dataLabels: {
                    enabled: false
                },
                stroke: {
                    curve: 'straight',
                },
                colors: ['#018394', '#dd3b15', '#f7a616'],
                title: {
                    text: 'Ordini degli ultimi 15 giorni',
                    align: 'left'
                },
                grid: {
                    row: {
                        colors: ['#f3f3f3', 'transparent'], // takes an array which will be repeated on columns
                        opacity: 0.5
                    },
                },
                xaxis: {
                    categories: [<?php echo "'".implode("','", $arrayDate)."'" ?>],
                }
            };
            
            var chart = new ApexCharts(document.querySelector("#graficoVisualizzazioni"), options);
            chart.render();
        </script>
    </body>
</html>
